function [ ] = LURNZ_Land_Use_Allocation_Module(last_year, pixel_size, output_path, Co2price, LUAM_PDFS, LUAM_ASCI, ALL_YEARS, harvest_age )
%
% Module 2 of LURNZ
% the land use allocation module spatially allocates changes in land used
% for dairy farming, sheep & beef farming, plantaion forestry or scrub.
%
% This default version of this script handles allocation at a national
% level. Supporting scripts will be written for allocating at TA or RC
% levels.
%

% Land Use Allocation Module (LUAM)
% Code by Simon Anastasiadis : 2011-11-03

%% Inform User Module Beginning

msg = sprintf(' - Land Use Allocation Module initialized');
disp(msg)

%% Load data

[c, LandUseChange, GISheader, LURNZDATA, forestHR ] = LUAM1_load_data(pixel_size, last_year, output_path );

%% Run analysis

% break point is inserted at the start of the following line
% in order to run NZ level validation
% before resuming, overwrite LandUseChange variable with desired values

[LU_endogenous, LU_exogenous, years, ForestAge_endogenous, ScrubAge_endogenous ] = LUAM2_spatial_land_allocation(c, LandUseChange, Co2price, LURNZDATA, forestHR, harvest_age );

%% Save output

LUAM3_save_results(LU_endogenous, LU_exogenous, GISheader, output_path, years, pixel_size, c, LURNZDATA, ForestAge_endogenous, ScrubAge_endogenous, LUAM_PDFS, LUAM_ASCI, ALL_YEARS );

%% Inform User Module Complete

msg = sprintf(' - Land Use Allocation Module complete');
disp(msg)

end

